% Obtain the linear approximation of a sinusoidal signal
%      simulate a sinusoidal signal x(n)=a sin(b * n  c) + d, for b>0
%      estimate a sequence x_s(m) obtained by sampling the signal x(n)
%      (e.g.: if n contains 500 values, m should contain 50)
%      computate the signal x_e(m+k), obtained by linear interpolation
%      (suggestion: interp1())
%      evaluate the accuracy

clear variables;
close all;

% simulate signal

fs = 10000;                                 % sampling frequency Hz
T = 1/fs;                                   % sampling period
tMax = 0.05;                                % total time
n = 0:T:tMax;                               % time vector
a = 1;                                      % amplitude 1
f1 = 50;                                    % signal frequency Hz
b = 2*pi*f1;                                % angular frequency (rad), period = 2*pi/b
c = 2*pi*0.75;                              % offset, phase shift = c/b
d = 0;                                      % vertical shift
x = a*sin(b*n - c) + d;                     % sinusoidal signal

% sampling

TS = T * 10;
m = n(1:10:end);
x_s = x(1:10:end);

% plot sampling results

figure
plot(n, x)                % continuous
hold on
plot(m, x_s, 'xr')        % sampled
xlabel('Time');
ylabel('x');                    
title 'Input signal';
legend('Input signal', 'Sampled signal')

% obtain linear interpolation

% New time axis
m_e = m(1: end-1) + 0.5 * TS;  
 
% Linear interpolation
x_e = interp1(m, x_s, m_e );

% plot fitted signal
figure
plot(n, x)                % input signal
hold on
plot(m, x_s, 'xr')         % sampled signal
plot(m_e, x_e, 'ok')     % fitted signal
xlabel('Time');
ylabel('x');                    
title 'Results';
legend('Input signal', 'Sampled signal', 'Fitted signal')


%Accuracy evaluation
 
% points of the input signal in the sampling instants
eElements = 5:10:size(n,2)-1;
 
% error vector
errorV = abs(x(eElements) - x_e);
 
% mean
meanE = mean(errorV);
 
% standard deviation
stdE = std(errorV);
 
% Print results

fprintf('\nRESULTS\n');
fprintf('Mean error = %f\n', meanE);
fprintf('Standard deviation of the error = %f\n', stdE);
 
% Visual analysis

% show error
figure
bar(m_e, errorV, 'r')
title 'Error'
xlabel('Time (ms)');
ylabel('\Delta_x'); 




